<?php

/*++++++++++++++++++++++++++++++++++++++++

  Script: Maian Gallery v2.0
  Written by: David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: http://www.maianscriptworld.co.uk

  ++++++++++++++++++++++++++++++++++++++++
  
  This File: settings.php
  Description: Program Settings

  ++++++++++++++++++++++++++++++++++++++++*/

// Make sure that this file is being called from parent file
if (!defined('INCLUDE_FILES')) {
  accessDenied($msg_script18,$msg_script19);
  exit;
}
 
include(FOLDER_PATH.'inc/currencies.inc.php');

// Set default lang..
$heading  = $msg_adminmenu3;
$msg      = $msg_settings17;

// Overwrite language if applicable..
if (isset($_SESSION['settings_tab']))
{
  switch ($_SESSION['settings_tab']) {
    case 'images':
    $heading  = $msg_settings24;
    $msg      = $msg_settings50;
    break;
    
    case 'watermarks':
    $heading  = $msg_settings19;
    $msg      = $msg_settings58;
    break;
    
    case 'cart':
    $heading  = $msg_settings33;
    $msg      = $msg_settings62;
    break;
    
    case 'smtp':
    $heading  = $msg_settings21;
    $msg      = $msg_settings63;
    break;
  }
}

?>
<div align="center">
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" class="msgBox">&raquo; <b><?php echo $heading; ?></b><br><br><?php echo $msg; ?></td>
</tr>
</table>
<form method="POST" action="index.php?cmd=settings">
<input type="hidden" name="process" value="1">
<table width="100%" cellspacing="0" cellpadding="0">
<tr>
  <td align="left">
  <table cellpadding="0" cellspacing="0" width="100%" class="menutable">
  <tr>
    <td align="left" class="leftPad">&raquo; <a href="index.php?cmd=settings&amp;tab=general" title="<?php echo $msg_settings; ?>" style="color:#FFFFFF;text-decoration:none"><b><?php echo strtoupper($msg_settings); ?></b></a></td>
  </tr>
  </table>
  </td>
  <td width="1">&nbsp;</td>
  <td align="left">
  <table cellpadding="0" cellspacing="0" width="100%" class="menutable">
  <tr>
    <td align="left" class="leftPad">&raquo; <a href="index.php?cmd=settings&amp;tab=images" title="<?php echo $msg_settings18; ?>" style="color:#FFFFFF;text-decoration:none"><b><?php echo strtoupper($msg_settings18); ?></b></a></td>
  </tr>
  </table>
  </td>
  <td width="1">&nbsp;</td>
  <td align="left">
  <table cellpadding="0" cellspacing="0" width="100%" class="menutable">
  <tr>
    <td align="left" class="leftPad">&raquo; <a href="index.php?cmd=settings&amp;tab=watermarks" title="<?php echo $msg_settings19; ?>" style="color:#FFFFFF;text-decoration:none"><b><?php echo strtoupper($msg_settings19); ?></b></a></td>
  </tr>
  </table>
  </td>
  <td width="1">&nbsp;</td>
  <td align="left">
  <table cellpadding="0" cellspacing="0" width="100%" class="menutable">
  <tr>
    <td align="left" class="leftPad">&raquo; <a href="index.php?cmd=settings&amp;tab=cart" title="<?php echo $msg_settings20; ?>" style="color:#FFFFFF;text-decoration:none"><b><?php echo strtoupper($msg_settings20); ?></b></a></td>
  </tr>
  </table>
  </td>
  <td width="1">&nbsp;</td>
  <td align="left">
  <table cellpadding="0" cellspacing="0" width="100%" class="menutable">
  <tr>
    <td align="left" class="leftPad">&raquo; <a href="index.php?cmd=settings&amp;tab=smtp" title="<?php echo $msg_settings21; ?>" style="color:#FFFFFF;text-decoration:none"><b><?php echo strtoupper($msg_settings21); ?></b></a></td>
  </tr>
  </table>
  </td>
</tr>
</table>

<?php
if (!isset($_SESSION['settings_tab']) || (isset($_SESSION['settings_tab']) && $_SESSION['settings_tab']=='general'))
{
?>
<!-- General Settings -->
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td width="30%" align="left" class="tdHeight"><b><?php echo $msg_settings2; ?></b>:</td>
        <td width="70%" align="left" class="tdHeight"><input class="formbox" type="text" name="website" size="25" maxlength="100" value="<?php echo cleanData($SETTINGS->website); ?>"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings4; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="email" size="25" maxlength="100" value="<?php echo $SETTINGS->email; ?>"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings5; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="homepage" maxlength="250" size="25" value="<?php echo $SETTINGS->homepage; ?>"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings6; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="folder" size="25" maxlength="250" value="<?php echo $SETTINGS->folder; ?>"> <?php echo toolTip($msg_javascript2,$msg_javascript3); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings55; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="folder_name" size="25" maxlength="250" value="<?php echo $SETTINGS->folder_name; ?>" style="width:25%"> <?php echo toolTip($msg_javascript2,$msg_javascript27); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings7; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="date_format" maxlength="25" size="25" value="<?php echo $SETTINGS->date_format; ?>" style="width:25%"> <?php echo toolTip($msg_javascript2,$msg_javascript4); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings22; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="mysql_date" maxlength="25" size="25" value="<?php echo $SETTINGS->mysql_date; ?>" style="width:25%"> <?php echo toolTip($msg_javascript2,$msg_javascript13); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings48; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="theme">
        <?php

        // Load themes..
        $showthemes = opendir(RELATIVE_PATH.'themes/');

        while ($read = readdir($showthemes))
        {
  	      if ($read != "." && $read != ".." && $read != "index.html" && $read!='email')
          {
        	  echo '<option'.(($read == $SETTINGS->theme) ? ' selected' : '').' style="padding-left:3px">'.$read.'</option>'."\n";
          }
        }

        closedir($showthemes);
        
        ?>
        </select></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings8; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="language">
        <?php

        // Load languages..
        $showlang = opendir(RELATIVE_PATH.'lang/');

        while ($read = readdir($showlang))
        {
  	      if ($read != "." && $read != ".." && $read != "index.html")
          {
        	  echo '<option'.(($read == $SETTINGS->language) ? ' selected' : '').' style="padding-left:3px">'.$read.'</option>'."\n";
          }
        }

        closedir($showlang);
        
        ?>
        </select></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings80; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="themeswitcher" value="1"<?php echo ($SETTINGS->themeswitcher ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript52); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings49; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="modr" value="1"<?php echo ($SETTINGS->modr ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript5); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings74; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="captcha" value="1"<?php echo ($SETTINGS->captcha ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript42); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings54; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="reset" value="1"> <?php echo toolTip($msg_javascript2,$msg_javascript26); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings78; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="keywords" size="25" value="<?php echo cleanData($SETTINGS->keywords); ?>"> <?php echo toolTip($msg_javascript2,$msg_javascript45); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings79; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="description" size="25" value="<?php echo cleanData($SETTINGS->description); ?>"> <?php echo toolTip($msg_javascript2,$msg_javascript46); ?></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<table width="100%" cellpadding="0" cellspacing="0" class="menutable">
<tr>
    <td align="left" class="leftPad">&raquo; <b><?php echo strtoupper($msg_settings25); ?></b></td>
</tr>
</table>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td align="left" class="tdHeight" colspan="2">
        <textarea name="aboutsite" rows="8" cols="30" style="width:98%"><?php echo cleanData($SETTINGS->aboutsite); ?></textarea><br>
        <span style="font-size:10px"><?php echo $msg_settings9; ?></span>
        </td>
    </tr>
    </table>
    </td>
</tr>
</table>
<table width="100%" cellpadding="0" cellspacing="0" class="menutable">
<tr>
    <td align="left" class="leftPad">&raquo; <b><?php echo strtoupper($msg_settings75); ?></b></td>
</tr>
</table>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td align="left" class="tdHeight" colspan="2">
        <textarea name="licence" rows="8" cols="30" style="width:98%"><?php echo cleanData($SETTINGS->licence); ?></textarea><br>
        <span style="font-size:10px"><?php echo $msg_settings9; ?></span>
        </td>
    </tr>
    <tr>
        <td align="center" class="tdHeight"><br><input name="generalbutton" type="submit" class="formbutton" value="<?php echo $msg_settings11; ?>" title="<?php echo $msg_settings11; ?>"></td>
    </tr>
    </table>
    </td>
</tr>
</table> 
<?php
}
?>

<!-- Images/Comments -->
<?php
if (isset($_SESSION['settings_tab']) && $_SESSION['settings_tab']=='images')
{
?>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td width="30%" class="tdHeight"><b><?php echo $msg_settings13; ?></b>:</td>
        <td width="70%" class="tdHeight"><input type="checkbox" name="autothumb" value="1"<?php echo ($SETTINGS->autothumb ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript8); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings14; ?></b>:</td>
        <td align="left" class="tdHeight">W: <input class="formbox" type="text" name="autowidth" size="25" maxlength="3" value="<?php echo $SETTINGS->autowidth; ?>" style="width:10%"> H: <input class="formbox" type="text" name="autoheight" maxlength="3" size="25" value="<?php echo $SETTINGS->autoheight; ?>" style="width:10%"> <?php echo toolTip($msg_javascript2,$msg_javascript9); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings15; ?></b>:</td>
        <td align="left" class="tdHeight">W: <input class="formbox" type="text" name="thumbwidth" maxlength="3" size="25" value="<?php echo $SETTINGS->thumbwidth; ?>" style="width:10%"> H: <input class="formbox" type="text" name="thumbheight" maxlength="3" size="25" value="<?php echo $SETTINGS->thumbheight; ?>" style="width:10%"> <?php echo toolTip($msg_javascript2,$msg_javascript10); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings69; ?></b>:</td>
        <td align="left" class="tdHeight">W: <input class="formbox" type="text" name="imgwidth" maxlength="3" size="25" value="<?php echo $SETTINGS->imgwidth; ?>" style="width:10%"> H: <input class="formbox" type="text" name="imgheight" maxlength="3" size="25" value="<?php echo $SETTINGS->imgheight; ?>" style="width:10%"> <?php echo toolTip($msg_javascript2,$msg_javascript16); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings10; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="thumbpage" size="25" maxlength="3" value="<?php echo $SETTINGS->thumbpage; ?>" style="width:10%"> <?php echo toolTip($msg_javascript2,$msg_javascript7); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings76; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="pagedisplaysize" size="25" maxlength="3" value="<?php echo $SETTINGS->pagedisplaysize; ?>" style="width:10%"> <?php echo toolTip($msg_javascript2,$msg_javascript43); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings77; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="windowsizes" size="25" value="<?php echo $SETTINGS->windowsizes; ?>" style="width:20%"> <?php echo toolTip($msg_javascript2,$msg_javascript44); ?></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<table cellpadding="0" cellspacing="1" width="100%" class="menutable">
<tr>
    <td align="left" class="leftPad">&raquo; <b><?php echo strtoupper($msg_settings71); ?></b></td>
</tr>
</table>    
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">  
    <tr>
        <td align="left" class="tdHeight" width="30%"><b><?php echo $msg_settings51; ?></b>:</td>
        <td align="left" class="tdHeight" width="70%"><input type="checkbox" name="comments" value="1"<?php echo ($SETTINGS->comments ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript20); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings56; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="approve" value="1"<?php echo ($SETTINGS->approve ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript21); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings57; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="verification" value="1"<?php echo ($SETTINGS->verification ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript28); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings88; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="comthumbpage" size="25" maxlength="3" value="<?php echo $SETTINGS->comthumbpage; ?>" style="width:10%"> <?php echo toolTip($msg_javascript2,$msg_javascript41); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings89; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="commentsorder">
        <option style="padding-left:3px" value="1"<?php echo ($SETTINGS->commentsorder ? ' selected' : ''); ?>><?php echo $msg_settings90; ?></option>
        <option style="padding-left:3px" value="0"<?php echo (!$SETTINGS->commentsorder ? ' selected' : ''); ?>><?php echo $msg_settings91; ?></option>
        </select> <?php echo toolTip($msg_javascript2,$msg_javascript55); ?></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<table cellpadding="0" cellspacing="1" width="100%" class="menutable">
<tr>
    <td align="left" class="leftPad">&raquo; <b><?php echo strtoupper($msg_settings72); ?></b></td>
</tr>
</table>  
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">  
    <tr>
        <td align="left" class="tdHeight" width="30%"><b><?php echo $msg_settings52; ?></b>:</td>
        <td align="left" class="tdHeight" width="70%"><input type="checkbox" name="slideshow" value="1"<?php echo ($SETTINGS->slideshow ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript29); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings73; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="slidewindow" size="25" maxlength="10" value="<?php echo $SETTINGS->slidewindow; ?>" style="width:15%"> <?php echo toolTip($msg_javascript2,$msg_javascript6); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings82; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="mp3">
        <option value="none"<?php echo ($SETTINGS->mp3=='' ? ' selected="selected"' : ''); ?>><?php echo $msg_settings84; ?></option>
        <?php

        // Load mp3 files..
        $showmp3 = opendir(RELATIVE_PATH.'mp3/');

        while ($read = readdir($showmp3))
        {
  	      if ($read != "." && $read != ".." && $read != "index.html" && $read!='email')
          {
        	  echo '<option'.(($read == $SETTINGS->mp3) ? ' selected="selected"' : '').' style="padding-left:3px">'.$read.'</option>'."\n";
          }
        }

        closedir($showmp3);
        
        ?>
        </select> <i>(<?php echo $msg_addimg14; ?>)</i> <?php echo toolTip($msg_javascript2,$msg_javascript53); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings83; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="slidespeeds" size="25" maxlength="100" value="<?php echo $SETTINGS->slidespeeds; ?>"> <?php echo toolTip($msg_javascript2,$msg_javascript38); ?></td>
    </tr>
    <tr>
        <td class="tdHeight">&nbsp;</td>
        <td align="left" class="tdHeight"><br><input name="imagesbutton" type="submit" class="formbutton" value="<?php echo $msg_settings11; ?>" title="<?php echo $msg_settings11; ?>"></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<?php
}
?>

<!-- Watermarks -->
<?php
if (isset($_SESSION['settings_tab']) && $_SESSION['settings_tab']=='watermarks')
{
?>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td width="30%" class="tdHeight"><b><?php echo $msg_settings35; ?></b>:</td>
        <td width="70%" class="tdHeight"><input type="checkbox" name="watermarks" value="1"<?php echo ($SETTINGS->watermarks ? ' checked="checked"' : ''); ?>></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings36; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="watertext" size="20" maxlength="50" value="<?php echo $SETTINGS->watertext; ?>"> (<i><?php echo $msg_script14.' 50 '.$msg_script15; ?></i>)</td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings37; ?></b>:</td>
        <td align="left" class="tdHeight"><?php echo $msg_settings38; ?>: <input class="formbox" type="text" name="watervspace" maxlength="3" size="25" value="<?php echo $SETTINGS->watervspace; ?>" style="width:10%"> <?php echo $msg_settings39; ?>: <input class="formbox" type="text" name="waterhspace" maxlength="3" size="25" value="<?php echo $SETTINGS->waterhspace; ?>" style="width:10%"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings44; ?></b>:</td>
        <td align="left" class="tdHeight">R: <input class="formbox" type="text" name="watertextr" size="8" maxlength="3" value="<?php echo $SETTINGS->watertextr; ?>" style="width:10%"> G: <input class="formbox" type="text" name="watertextg" size="8" maxlength="3" value="<?php echo $SETTINGS->watertextg; ?>" style="width:10%"> B: <input class="formbox" type="text" name="watertextb" size="8" maxlength="3" value="<?php echo $SETTINGS->watertextb; ?>" style="width:10%"> <a href="index.php?cmd=settings&amp;view=rgb" title="<?php echo $msg_settings46; ?>" rel="gb_page_center[400, 220]"><img src="images/sel.gif" border="0" alt="<?php echo $msg_settings46; ?>" title="<?php echo $msg_settings46; ?>"></a></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings40; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="waterfont">
        <option style="padding-left:3px" value="arial"<?php echo ($SETTINGS->waterfont=="arial" ? ' selected' : ''); ?>><?php echo $msg_settings59; ?></option>
        <option style="padding-left:3px" value="times"<?php echo ($SETTINGS->waterfont=="times" ? ' selected' : ''); ?>><?php echo $msg_settings60; ?></option>
        <option style="padding-left:3px" value="verdana"<?php echo ($SETTINGS->waterfont=="verdana" ? ' selected' : ''); ?>><?php echo $msg_settings61; ?></option>
        </select></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings41; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="watersize">
        <option style="padding-left:3px" value="8"<?php echo ($SETTINGS->watersize=="8" ? ' selected' : ''); ?>>8px</option>
        <option style="padding-left:3px" value="9"<?php echo ($SETTINGS->watersize=="9" ? ' selected' : ''); ?>>9px</option>
        <option style="padding-left:3px" value="10"<?php echo ($SETTINGS->watersize=="10" ? ' selected' : ''); ?>>10px</option>
        <option style="padding-left:3px" value="11"<?php echo ($SETTINGS->watersize=="11" ? ' selected' : ''); ?>>11px</option>
        <option style="padding-left:3px" value="12"<?php echo ($SETTINGS->watersize=="12" ? ' selected' : ''); ?>>12px</option>
        <option style="padding-left:3px" value="13"<?php echo ($SETTINGS->watersize=="13" ? ' selected' : ''); ?>>13px</option>
        <option style="padding-left:3px" value="14"<?php echo ($SETTINGS->watersize=="14" ? ' selected' : ''); ?>>14px</option>
        <option style="padding-left:3px" value="16"<?php echo ($SETTINGS->watersize=="16" ? ' selected' : ''); ?>>16px</option>
        <option style="padding-left:3px" value="18"<?php echo ($SETTINGS->watersize=="18" ? ' selected' : ''); ?>>18px</option>
        <option style="padding-left:3px" value="20"<?php echo ($SETTINGS->watersize=="20" ? ' selected' : ''); ?>>20px</option>
        <option style="padding-left:3px" value="22"<?php echo ($SETTINGS->watersize=="22" ? ' selected' : ''); ?>>22px</option>
        <option style="padding-left:3px" value="24"<?php echo ($SETTINGS->watersize=="24" ? ' selected' : ''); ?>>24px</option>
        <option style="padding-left:3px" value="26"<?php echo ($SETTINGS->watersize=="26" ? ' selected' : ''); ?>>26px</option>
        <option style="padding-left:3px" value="36"<?php echo ($SETTINGS->watersize=="36" ? ' selected' : ''); ?>>36px</option>
        <option style="padding-left:3px" value="48"<?php echo ($SETTINGS->watersize=="48" ? ' selected' : ''); ?>>48px</option>
        <option style="padding-left:3px" value="72"<?php echo ($SETTINGS->watersize=="72" ? ' selected' : ''); ?>>72px</option>
        </select></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings42; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="waterangle">
        <option<?php echo ($SETTINGS->waterangle=="5" ? ' selected' : ''); ?> style="padding-left:3px">5</option>
        <option<?php echo ($SETTINGS->waterangle=="10" ? ' selected' : ''); ?> style="padding-left:3px">10</option>
        <option<?php echo ($SETTINGS->waterangle=="15" ? ' selected' : ''); ?> style="padding-left:3px">15</option>
        <option<?php echo ($SETTINGS->waterangle=="20" ? ' selected' : ''); ?> style="padding-left:3px">20</option>
        <option<?php echo ($SETTINGS->waterangle=="25" ? ' selected' : ''); ?> style="padding-left:3px">25</option>
        <option<?php echo ($SETTINGS->waterangle=="30" ? ' selected' : ''); ?> style="padding-left:3px">30</option>
        <option<?php echo ($SETTINGS->waterangle=="35" ? ' selected' : ''); ?> style="padding-left:3px">35</option>
        <option<?php echo ($SETTINGS->waterangle=="40" ? ' selected' : ''); ?> style="padding-left:3px">40</option>
        <option<?php echo ($SETTINGS->waterangle=="45" ? ' selected' : ''); ?> style="padding-left:3px">45</option>
        <option<?php echo ($SETTINGS->waterangle=="50" ? ' selected' : ''); ?> style="padding-left:3px">50</option>
        <option<?php echo ($SETTINGS->waterangle=="55" ? ' selected' : ''); ?> style="padding-left:3px">55</option>
        <option<?php echo ($SETTINGS->waterangle=="60" ? ' selected' : ''); ?> style="padding-left:3px">60</option>
        <option<?php echo ($SETTINGS->waterangle=="65" ? ' selected' : ''); ?> style="padding-left:3px">65</option>
        <option<?php echo ($SETTINGS->waterangle=="70" ? ' selected' : ''); ?> style="padding-left:3px">70</option>
        <option<?php echo ($SETTINGS->waterangle=="75" ? ' selected' : ''); ?> style="padding-left:3px">75</option>
        <option<?php echo ($SETTINGS->waterangle=="80" ? ' selected' : ''); ?> style="padding-left:3px">80</option>
        <option<?php echo ($SETTINGS->waterangle=="85" ? ' selected' : ''); ?> style="padding-left:3px">85</option>
        <option<?php echo ($SETTINGS->waterangle=="90" ? ' selected' : ''); ?> style="padding-left:3px">90</option>
        </select> &deg; <?php echo $msg_settings43; ?></td>
    </tr>
    <tr>
        <td class="tdHeight">&nbsp;</td>
        <td align="left" class="tdHeight"><br><input name="waterbutton" type="submit" class="formbutton" value="<?php echo $msg_settings11; ?>" title="<?php echo $msg_settings11; ?>">&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?cmd=settings&amp;watermark=1" rel="gb_page_center[680, 540]" title="<?php echo $msg_settings45; ?>"><?php echo $msg_settings45; ?></a></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<?php
}
?>

<!-- Paypal IPN -->
<?php
if (isset($_SESSION['settings_tab']) && $_SESSION['settings_tab']=='cart')
{
?>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td width="30%" class="tdHeight"><b><?php echo $msg_settings23; ?></b>:</td>
        <td width="70%" class="tdHeight"><input type="checkbox" name="cart" value="1"<?php echo ($SETTINGS->cart ? ' checked="checked"' : ''); ?>></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings53; ?></b>:</td>
        <td align="left" class="tdHeight"><select name="ppCurrency">
        <?php
        foreach ($currencies AS $key => $value)
        {
        ?>
        <option style="padding-left:3px" value="<?php echo $key; ?>"<?php echo ($PP->ppCurrency==$key ? ' selected' : ''); ?>><?php echo $value; ?></option>
        <?php
        }
        ?>
        </select>
        </td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings27; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="ppEmail" size="25" maxlength="250" value="<?php echo cleanData($PP->ppEmail); ?>"> <?php echo toolTip($msg_javascript2,$msg_javascript19); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings26; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="ppStyle" size="25" value="<?php echo cleanData($PP->ppStyle); ?>"> <?php echo toolTip($msg_javascript2,$msg_javascript23); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings32; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="ppLog" value="1"<?php echo ($PP->ppLog ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript22); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings81; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="ppSSL" value="1"<?php echo ($PP->ppSSL ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript51); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings28; ?></b>:</td>
        <td align="left" class="tdHeight"><input type="checkbox" name="ppSandbox" value="1"<?php echo ($PP->ppSandbox ? ' checked="checked"' : ''); ?>> <?php echo toolTip($msg_javascript2,$msg_javascript24); ?></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<table width="100%" cellpadding="0" cellspacing="0" class="menutable">
<tr>
    <td align="left" class="leftPad">&raquo; <b><?php echo strtoupper($msg_settings85); ?></b></td>
</tr>
</table>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td width="30%" class="tdHeight"><b><?php echo $msg_settings86; ?></b>:</td>
        <td width="70%" class="tdHeight"><input class="formbox" type="text" name="ppShipDefault" size="25" value="<?php echo cleanData($PP->ppShipDefault); ?>" style="width:15%"> <?php echo toolTip($msg_javascript2,$msg_javascript39); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings87; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="ppShipSingle" size="25" value="<?php echo cleanData($PP->ppShipSingle); ?>" style="width:15%"> <?php echo toolTip($msg_javascript2,$msg_javascript40); ?></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight">&nbsp;</td>
        <td align="left" class="tdHeight"><br><input name="cartbutton" type="submit" class="formbutton" value="<?php echo $msg_settings11; ?>" title="<?php echo $msg_settings11; ?>"></td>
    </tr>
    </table>
    </td>
</tr>
</table>    
<?php
}
?>

<!-- SMTP -->
<?php
if (isset($_SESSION['settings_tab']) && $_SESSION['settings_tab']=='smtp')
{
?>
<table width="100%" border="0" cellpadding="0" cellspacing="1" style="border: 2px solid #083253">
<tr>
    <td align="left" valign="top" class="msgBox">
    <table width="100%" border="0" cellpadding="0" cellspacing="2">
    <tr>
        <td width="30%" class="tdHeight"><b><?php echo $msg_settings64; ?></b>:</td>
        <td width="70%" class="tdHeight"><input type="checkbox" name="smtp" value="1"<?php echo ($SETTINGS->smtp ? ' checked="checked"' : ''); ?>></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings65; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="smtp_host" size="25" maxlength="250" value="<?php echo cleanData($SETTINGS->smtp_host); ?>"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings66; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="smtp_user" size="25" maxlength="250" value="<?php echo cleanData($SETTINGS->smtp_user); ?>"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings67; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="smtp_pass" size="25" maxlength="250" value="<?php echo cleanData($SETTINGS->smtp_pass); ?>"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight"><b><?php echo $msg_settings68; ?></b>:</td>
        <td align="left" class="tdHeight"><input class="formbox" type="text" name="smtp_port" size="25" maxlength="250" value="<?php echo cleanData($SETTINGS->smtp_port); ?>" style="width:10%"></td>
    </tr>
    <tr>
        <td align="left" class="tdHeight">&nbsp;</td>
        <td align="left" class="tdHeight"><br><input name="smtpbutton" type="submit" class="formbutton" value="<?php echo $msg_settings11; ?>" title="<?php echo $msg_settings11; ?>"></td>
    </tr>
    </table>
    </td>
</tr>
</table>
<?php
}
?>
</form>
</div>
